/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.result;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.report.result.MultiRequestFlowCapacityTableRow;
import cz.insophy.inplan.report.result.MultiRequestFlowMaterialTableRow;
import cz.insophy.inplan.report.result.MultiRequestFlowPath;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.Localizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiRequestFlowActivityTableRow {
    private final int number;
    private final Collection<MultiRequestFlowPath> paths;
    private final MultiRequestFlowPath path;
    private final GeneralizedOrderRequest gor;
    private final GeneralizedActionRequest gar;
    private final GeneralizedActionRequest prevGar;
    private final GeneralizedActionRequest nextGar;

    public MultiRequestFlowActivityTableRow(int number, MultiRequestFlowPath path, Collection<MultiRequestFlowPath> paths, GeneralizedActionRequest gar) {
        this.number = number;
        this.paths = paths;
        this.gar = gar;
        this.path = path;
        this.gor = path.getGor(gar);
        this.prevGar = path.getPreviousGar(gar);
        this.nextGar = path.getNextGar(gar);
    }

    public int getNumber() {
        return this.number;
    }

    public GeneralizedActionRequest getGar() {
        return this.gar;
    }

    public GeneralizedOrderRequest getGor() {
        return this.gor;
    }

    public Action getAction() {
        return this.gar.getAction();
    }

    public long getRealStartTime() {
        return this.gar.getStartDate();
    }

    public long getPossibleStartTime() {
        long max = Long.MIN_VALUE;
        for (MultiRequestFlowPath temp : this.paths) {
            for (MultiRequestFlowActivityTableRow activity : temp.getActivityRows()) {
                if (this.gar != activity.gar) continue;
                max = Math.max(max, activity.getFixedStartTime());
            }
        }
        return max;
    }

    public long getFixedStartTime() {
        if (this.prevGar == null) {
            return this.gar.getReleaseDate();
        }
        return Math.min(this.prevGar.getEndDate(), this.gar.getStartDate());
    }

    public long getFixedEndTime() {
        if (this.nextGar == null) {
            return this.gar.getEndDate();
        }
        return Math.min(this.nextGar.getStartDate(), this.gar.getEndDate());
    }

    public long getTotalTime() {
        if (!GeneralizedRequest.isDateValid(this.getFixedStartTime()) || !GeneralizedRequest.isDateValid(this.getFixedEndTime())) {
            return 0L;
        }
        return Math.max(0L, this.getFixedEndTime() - this.getFixedStartTime());
    }

    public long getTotalTimeForInfluence() {
        long start = this.getPossibleStartTime();
        long end = this.getFixedEndTime();
        return Math.max(0L, end - start);
    }

    public long getProductionTime() {
        return ReportUtilities.getProductionTime(this.gar);
    }

    public long getLogisticTime() {
        return ReportUtilities.getLogisticTime(this.gar, this.prevGar);
    }

    public long getWaitingTime() {
        long total = this.getTotalTime();
        long production = this.getProductionTime();
        long logistics = this.getLogisticTime();
        return Math.max(0L, total - production - logistics);
    }

    public long getInnerWaitingTime() {
        long total = this.getTotalTimeForInfluence();
        long production = this.getProductionTime();
        long logistics = this.getLogisticTime();
        return Math.max(0L, total - production - logistics);
    }

    public long getOuterWaitingTime() {
        return this.getWaitingTime() - this.getInnerWaitingTime();
    }

    public List<MultiRequestFlowMaterialTableRow> getMaterialRows() {
        ArrayList<MultiRequestFlowMaterialTableRow> rows = Lists.newArrayList();
        for (Map.Entry<Material, Long> entry : this.path.getMaterials(this.gar).entrySet()) {
            rows.add(new MultiRequestFlowMaterialTableRow(entry.getKey(), entry.getValue(), this.getPossibleStartTime()));
        }
        Collections.sort(rows, new Comparator<MultiRequestFlowMaterialTableRow>(){

            @Override
            public int compare(MultiRequestFlowMaterialTableRow o1, MultiRequestFlowMaterialTableRow o2) {
                return Comparators.compare(o2.getDateDifference(), o1.getDateDifference());
            }
        });
        return Collections.unmodifiableList(rows);
    }

    public List<MultiRequestFlowCapacityTableRow> getCapacityRows() {
        ArrayList<MultiRequestFlowCapacityTableRow> rows = Lists.newArrayList();
        for (Map.Entry<Workplace, ActionActivity> entry : MultiRequestFlowActivityTableRow.findLastActivity(this.gar.getActivities()).entrySet()) {
            long lookupStart = Math.max(this.getPossibleStartTime(), this.getFixedStartTime() + this.getLogisticTime());
            long lookupEnd = entry.getValue().getEnd();
            if (lookupEnd <= lookupStart) continue;
            MultiRequestFlowActivityTableRow.collectActivities(rows, entry.getValue().getPlan().getWorkplaceSchedule(entry.getKey()), lookupStart, lookupEnd, this.gar);
        }
        return Collections.unmodifiableList(rows);
    }

    private static Map<Workplace, ActionActivity> findLastActivity(List<ActionActivity> data) {
        HashMap<Workplace, ActionActivity> result = Maps.newHashMap();
        for (ActionActivity aa : data) {
            if (result.containsKey(aa.getWorkplace())) {
                if (aa.getEnd() <= ((ActionActivity)result.get(aa.getWorkplace())).getEnd()) continue;
                result.put(aa.getWorkplace(), aa);
                continue;
            }
            result.put(aa.getWorkplace(), aa);
        }
        return Collections.unmodifiableMap(result);
    }

    private static void collectActivities(List<MultiRequestFlowCapacityTableRow> rows, WorkplaceSchedule ws, long lookupStart, long lookupEnd, GeneralizedActionRequest garToIgnore) {
        WorkplaceActivity wa;
        Iterator<WorkplaceActivity> iterable = ws.backwardIterator(lookupEnd, false);
        long total = Math.max(0L, lookupEnd - lookupStart);
        HashMap<GeneralizedOrderRequest, Long> gorTime = Maps.newHashMap();
        long rebuildSum = 0L;
        long offlineSum = 0L;
        long cumulativeSum = 0L;
        long productionSum = 0L;
        block0: while (iterable.hasNext() && (wa = iterable.next()).getEnd() > lookupStart) {
            long length = ReportUtilities.getOverlap(wa.getStart(), wa.getEnd(), lookupStart, lookupEnd);
            if (wa instanceof ActionActivity) {
                if (((ActionActivity)wa).getGar() == garToIgnore) continue;
                GeneralizedOrderRequest wagor = ((ActionActivity)wa).getNearestGor();
                if (gorTime.containsKey(wagor)) {
                    gorTime.put(wagor, (Long)gorTime.get(wagor) + length);
                } else {
                    gorTime.put(wagor, length);
                }
                productionSum += length;
                continue;
            }
            if (wa instanceof CumulativeWorkplaceActivity) {
                for (ActionActivity aa : ((CumulativeWorkplaceActivity)wa).getActionActivities()) {
                    if (aa.getGar() != garToIgnore) continue;
                    continue block0;
                }
                cumulativeSum += length;
                productionSum += length;
                continue;
            }
            if (wa instanceof OfflineActivity) {
                offlineSum += length;
                continue;
            }
            if (!(wa instanceof RebuildActivity)) continue;
            rebuildSum += length;
        }
        for (Map.Entry entry : gorTime.entrySet()) {
            if ((Long)entry.getValue() <= 0L) continue;
            rows.add(new MultiRequestFlowCapacityTableRow((GeneralizedOrderRequest)entry.getKey(), (long)((Long)entry.getValue()), total));
        }
        if (productionSum > 0L) {
            rows.add(new MultiRequestFlowCapacityTableRow(Localizer.getString("report.multi_request_flow.table.capacity.production"), productionSum, total));
        }
        if (cumulativeSum > 0L) {
            rows.add(new MultiRequestFlowCapacityTableRow(Localizer.getString("report.multi_request_flow.table.capacity.cumulative"), cumulativeSum, total));
        }
        if (offlineSum > 0L) {
            rows.add(new MultiRequestFlowCapacityTableRow(Localizer.getString("report.multi_request_flow.table.capacity.offline"), offlineSum, total));
        }
        if (rebuildSum > 0L) {
            rows.add(new MultiRequestFlowCapacityTableRow(Localizer.getString("report.multi_request_flow.table.capacity.rebuild"), rebuildSum, total));
        }
    }
}

